// VERSION: Scilab: 5.4.1 
// OS: windows 7

//CAPTION: To perform addition and subtraction of the following two DT signals
//Xa(t) =   1; 0<t<1
//          2; 1<t<2;
//          1; 2<t<3

// & 
// Xb(t) = t; 0<t<1
//         1; 1<t<2;
//         3-t; 2<t<3

//////*******************************////////////////////////

clc;
clear all;
close
t = -1:0.1:5;
x1 = 1;
x2 = 2;
x3 = 3-t;

xa = x1.*(t>0 & t<1) + x2.*(t>=1 & t<=2) + x1.*(t>2 & t<3);
xb = t.*(t>0 &t<1) + x1*(t>=1 &t<=2)+x3.*(t>2 &t<3);

xadd = xa +xb;
xmul = xa.*xb;
subplot(2,3,1);
plot2d3(t,xa)  //Plots input signal xa
xlabel('t');
ylabel('Amplitude');
title('input signal xa');
subplot(2,3,2);
plot2d3(t,xb)  //Plots input signal xb
xlabel('t');
ylabel('Amplitude');
title('input signal xb');
subplot(2,3,3);
plot2d3(t,xadd)  //Plots addition of signal xa and xb
xlabel('t');
ylabel('Amplitude');
title('Addition of two signals, xadd');
subplot(2,3,4);
plot2d3(t,xmul)  //Plots Multiplication of signal xa and xb
xlabel('t');
ylabel('Amplitude');
title('Multiplication of two signals, xmul');

//// Output : In Graphic Window

